package it.unipv.ticket.dao;

import it.unipv.ticket.entity.Ticket;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
public class TicketDao {

	@PersistenceContext
	EntityManager em;
	
	public Ticket createTicket(Date date, BigDecimal price, String row, String seat) {
		Ticket ticket = new Ticket();			
		ticket.setDate(date);
		ticket.setPrice(price);
		ticket.setRow(row);
		ticket.setSeat(seat);
		em.persist(ticket);
		return ticket;
	}
	
	public Ticket findTicket(int ticketId) {
		Ticket ticket = em.find(Ticket.class, ticketId);
		return ticket;
	}
	
	public List<Ticket> findAllTickets() {		
		String jpql = "Select t from Ticket t";
		TypedQuery<Ticket> query = em.createQuery(jpql, Ticket.class);
		List<Ticket> listOfTickets = query.getResultList();
		return listOfTickets;
	}
	
	public int deleteTicket(Ticket ticket) {
		try {
			em.remove(ticket);
		} catch (Exception e) {
			e.printStackTrace();
			return -1;
		}
		return 0;
	}
	
}
