package it.unipv.ticket.controller;

import it.unipv.ticket.dao.TicketDao;
import it.unipv.ticket.entity.Performance;
import it.unipv.ticket.entity.Seat;
import it.unipv.ticket.entity.Ticket;

import java.util.Date;

import javax.ejb.Stateless;
import javax.inject.Inject;

@Stateless
public class TicketController {

	@Inject TicketDao ticketDao;
	@Inject PerformanceController performanceController;
	
	/**
	 * Selects a price band and a seat available for a perfomance
	 * and sells a ticket
	 * @param date
	 * @return
	 * @throws Exception 
	 */
	public Ticket purchaseTicket(Performance perfomance, Date date) throws Exception {
		
		// Check if the date is adequate
		if (date.after(new java.util.Date())) {
			throw new Exception("You cannot book on past dates!!!");
		}
		
		// Find a free seat for performance
		Seat seat = performanceController.findFreeSeat(date);
		
		// Sell the ticket
		Ticket ticket = null;
		if (seat!=null) {
		 ticket = ticketDao.createTicket(date, seat.getPrice(), seat.getRow(), seat.getSeat());
		}
		
		// Return the ticket sold
		return ticket;
		
	}
	
}
